function [x, i] = broyden(f, x0, eps, nmax)
    n = length (x0);
    x = x0;
    B = eye(n);
    dx = x*0.5;
    i = 1;
    while norm(dx)>eps && i<nmax
        df = f(x + dx) - f(x);
        B = B + ((df - B*dx)*dx')/(dx'*dx);
        x = x + dx;
        if cond(B)>1e3 || det(B)<1e-3
            dx = pinv(B)*(-f(x)); % rosszul kondicionlt esetben
        else
            dx = linsolve(B,-f(x));
        end
        i = i + 1;
    end
end

