function [x i] = golden(f, a, b, r, Tolx, Tolf, i)
% Az eljrs rekurzv aranymetszs mdszer segtsgvel hatrozza 
% meg egy egy vltozs nemlineris fggvny minimumuhelyt
%
% Bemen paramterek:
%   f - egyvltozs fggvny
%   a - az intervallum bal oldala
%   b - az intervallum jobb oldala
%   r - a feloszts paramtere, egyenl feloszts esetn: 2/3
%   Tolx - lellsi felttel, intervallum hossza
%   Tolf - lellsi felttel, fggvnyrtkek eltrse
%   i - itercik szma,  a fggvny hvsakor i = 0
%
% Kimenet:
%   x - A megolds helye
%   i - Itercik szma 
%
% Ksztette: XY
% Dtum: XXX
%

% az itercik szma egyel n, ahnyszor csak meghvjuk a fggvnyt:
i = i + 1;
h = b - a;
c = a + (1 - r)*h;
d = a + r*h;
fc = f (c);
fd = f (d);
% Lellsi felttel: 
% vagy:
% 1., az intervallum hossza a megadott 'Tolx' kszbrtk al cskkent
% vagy:
% 2., a fggvnyrtkek klnbsge az intervallum vgpontjaiban
%     a megadott 'Tolf' kszbrtk al cskkent
if (abs(h) < Tolx || abs(fc - fd) < Tolf) % || logikai 'vagy' mvelet
   if fc <= fd
      x = c;
   else
       x = d;
   end
else
    if fc < fd
      [x i] = golden(f, a, d, r, Tolx, Tolf, i);  % rekurzv fggvnyhvs az j intervallumra
   else
      [x i] = golden(f, c, b, r, Tolx, Tolf, i);  % rekurzv fggvnyhvs az j intervallumra
    end
end
