function [x1 i] = wegstein(g, x0, e, imax)
    x1=g(x0);
    x2=(x0*g(x1) - g(x0)*x1) / (x0 - x1 + g(x1) - g(x0));
    i=1;
    
    while abs((x2-x1)/x2) > e && i<=imax
        x0 = x1;
        x1 = x2;
        x2 = (x0*g(x1) - g(x0)*x1) / (x0 - x1 + g(x1) - g(x0));
        i=i+1;
    end
end