function [x1, n] = wegsteinsys (g, x0, eps, nmax)
    x1 = g(x0);
    n = 1;
    while norm(x1-x0)>eps && n<=nmax 
        gx0 = g(x0);
        gx1 = g(x1);
        c = 1./(1 - (gx1 - gx0)./(x1 - x0));
        x2 = c.*gx1 + (1 - c).*x1;
        x0 = x1;
        x1 = x2;
        n = n + 1;
    end;
end