function [x i X] = gradmulti(grad, hesse, x0, eps, nmax)
% Az eljrs a Newton-mdszer segtsgvel hatrozza 
% meg egy ktvltozs fggvny minimumuhelyt
%
% Bemen paramterek:
%   grad  - a gradiens vektor szmtsra szolgl fggvny
%   hesse - a Hesse mtrix szmtsra szolgl fggvny
%   x0 - a kezdrtk vektora
%   eps   - lellsi felttel, minimlis lpshossz rtke
%   nmax  - lellsi felttel, maximlis iterc szm
%
% Kimenet:
%   x - A megolds helye
%   i - Itercik szma
%   X - az egyes itercis lpsek mtrixa

x1 = x0 - pinv(hesse(x0))*grad(x0);
i=1;
X=[x0 x1];

% Lellsi felttelek: 
% 1., a lpshossz a megadott 'eps' kszbrtk al cskkent,vagy 
% 2., elrtk a maximlis itercik 'nmax' szmt
while and(norm(x1 - x0) > eps, i < nmax)
	x0 = x1;
	x1 = x0 - pinv(hesse(x0))*grad(x0);
	i = i + 1;
	X = [X x1];
end
x = x1;
