function [c, i] = hur(f, a, b, delta, N)
% Az eljrs a hr mdszer segtsgvel hatrozza meg 
% egy egyvltozs nemlineris egyenlet megoldst
%
% Bemen paramterek:
%   f - egyvltozs fggvny, aminek a gykhelyt keressk
%   a,b - a zrt intervallum bal s jobb oldala
%   delta - lellsi felttel, kzeltts kszbrtke
%   N - lellsi felttel, maximlis iterc szm
%
% Kimenet:
%   c - A megolds helye
%   i - Itercik szma

    % A hrnak az x tengellyel val metszse - 1. iterci
    c = (a*f(b) - b*f(a))/(f(b) - f(a));   
    i = 1;   % Itercik szma

    % Lellsi felttel: 
    % elrjk a kzelts kszbrtkt vagy a maximlis iterci szmot
    while abs (f(c)) > delta && i <= N
        if f(c)*f(a) < 0
            b = c;
        else
            a = c;
        end;
        i = i + 1;
        c = (a*f(b) - b*f(a))/(f(b) - f(a));
    end;
end
