function [x, i] = intervallum(f, a, b, tol)
% Az eljrs az intervallum-mdszer segtsgvel hatrozza 
% meg egy egy vltozs nemlineris fggvny minimumuhelyt
%
% Bemen paramterek:
%   f - egyvltozs fggvny
%   a - az intervallum bal oldala
%   b - az intervallum jobb oldala
%   tol - lellsi felttel, intervallum hossza
% Kimenet:
%   x - A megolds helye
%   i - Itercik szma 

 i = 1;
 x1 = a + 1/3*(b-a);
 x2 = b - 1/3*(b-a);
 while abs(x2-x1) > tol 
   if f(x1) < f(x2)
     b = x2;
   else
     a = x1;
   end
   i = i+1;
   x1 = a + 1/3*(b-a);
   x2 = b - 1/3*(b-a);
 end  
 x = (x1+x2)/2;
end

