function [c, i] = intfelezes(f, a, b, delta, N)
% Az eljrs az intervallum felezs mdszer segtsgvel hatrozza 
% meg egy egyvltozs nemlineris egyenlet megoldst
%
% Bemen paramterek:
%   f - egyvltozs fggvny, aminek a gykhelyt keressk
%   a,b - a zrt intervallum bal s jobb oldala
%   delta - lellsi felttel, kzelts kszbrtke
%   N - lellsi felttel, maximlis iterci szm
%
% Kimenet:
%   c - A megolds helye
%   i - Itercik szma

    c = (a+b)/2;    % Intervallumfelezs (1. iterci)
    i = 1;          % Itercik szma

    % Lellsi felttel: 
    % elrjk a kzelts kszbrtkt vagy a maximlis iterci szmot
    while abs (f(c)) > delta && i <= N
        if f(c)*f(a) < 0
            b = c;
        else
            a = c;
        end;
        i = i + 1;
        c = (a+b)/2;
    end;
end
