function [x,i,X]=iterativ(A,b,e,imax,method)
% A*x=b Lineris egyenletrendszer megoldsa iteratv mdon,
% Jacobi vagy Gauss-Seidel mdszerrel (alaprtelmezett: Jacobi).
% Bemenet: A, b, e-hibahatr, imax - maximlis iterci szm
% method - 'Jacobi' vagy 'GaussSeidel' (nem ktelez megadni)
% Kimenet: x-megolds, i -iterci szm, X-itercis lpsek

% Mdszer meghatrozsa
    if nargin==4; method='Jacobi'; end
    switch method
        case 'Jacobi'
            B = diag(diag(A));  % A mtrix ftlja mtrixban
        case 'GaussSeidel'
            B=tril(A);  % A mtrix als hromszg
        otherwise % Jacobi
            B = diag(diag(A)); % A mtrix ftlja mtrixban
    end
% Els itercis lps
Ai=eye(5)-inv(B)*A;
bi = inv(B)*b;
x0=ones(size(b)); % kiindul rtk
i=1; x1=Ai*x0+bi; % Els iterci
X=[x0,x1];
% Itercis ciklus
while i<=imax && norm(x1-x0)>e
    x0=x1;
    x1=Ai*x0+bi;
    X=[X,x1];
    i=i+1;
end
x=X(:,end); % megolds
end